# coding=utf-8
# 得到200bp窗口的bed文件，并统计每个窗口正负链所含srna的个数
import os
import sys
# 得到含起始位置的bed文件
out = open('mit.txt', 'w')
text = '%s\t%d' % ('NC_045512.2', 29903)
print >> out, text
out.close()
input_txt = 'mit.txt'
out_bed = 'mit.bed'
windows_size = 200  # 设置窗口大小
cmd1 = 'bedtools makewindows -g %s -w %d > %s' % (input_txt, windows_size, out_bed)
os.system(cmd1)


def list_open(file):
    with open(file, 'r') as f:
        dic = []
        # lines = f.readlines()[1:] #不读取第一行
        # for line in lines
        for line in f.readlines():
            line = str(line).strip('\n')
            result = line.split('\t')
            dic.append(result)
        return dic


input_file = sys.argv[1]  # 要统计的已经排序过的bam 文件
out_file='%s%s'%(input_file,'.txt')
temp_sam = '%s%s'%(input_file,'.sam')
output_data = []
dic1 = list_open(out_bed)
for i in dic1:
    start = i[1]
    end = i[-1]
    cmd2 = 'samtools view %s NC_045512.2:%s-%s > %s' % (input_file, start, end, temp_sam)
    os.system(cmd2)
    dic2 = list_open(temp_sam)
    a = 0
    b = 0
    for j in dic2:
        if j[1] == '0':
            a += 1
        else:
            b += 1
    output_data.append('%s\t%s' % (a, b))

with open(out_file, 'w') as out:
    print >> out, '%s\t%s' % ('+', '-')
    print >> out, '\n'.join(output_data)
os.remove(input_txt)
os.remove(out_bed)
os.remove(temp_sam)
